<!--2011-04-28 ajout du controle de Luhn pour la verification de la validité des codes SIRET
    ajout de la verification des codes gelés--><!--2013-10-24 Ajout de la règle d'avertissement de contrôle du jeu de données de référence des stations de mesures cours d'eau, plan d'eau--><!--2014-04-28 Ajout du fichier de configuration STQ_simplifie pour le controle des stations de mesure QES --><!--2014-04-29 Ajout du fichier ODP_simplifie pour le controle des systèmes de traitement d'eaux usées--><!--2015-04-14 Optimisation des règles de controle de validation des paramètres, unités de mesure, supports et fractions analysées-->
<axsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sa_ref31="http://xml.sandre.eaufrance.fr/scenario/referentiel/3.1" xmlns:sa_ref="http://xml.sandre.eaufrance.fr/scenario/referentiel/2" xmlns:xx="http://xml.sandre.eaufrance.fr/scenario/labo_dest/1" xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" version="1.0">
    <axsl:output method="text" omit-xml-declaration="no" standalone="yes" indent="yes"/>
    <!--<axsl:variable name="chemin">http://195.220.97.105:8080/exist/xmldb/db/sandre/Referentiels/old_referentiel.xml</axsl:variable>-->
    <axsl:variable name="cheminPAR">PAR.xml</axsl:variable>
    <axsl:variable name="cheminMET">MET.xml</axsl:variable>
    <axsl:variable name="cheminSUP">SUP.xml</axsl:variable>
    <axsl:variable name="cheminFAN">FAN.xml</axsl:variable>
    <axsl:variable name="cheminURF">URF.xml</axsl:variable>
    <axsl:variable name="cheminODP">ODP_simplifie.xml</axsl:variable>
    <axsl:variable name="cheminSTQ">STQ_simplifie.xml</axsl:variable>
    <axsl:variable name="cheminSCL">SCL.xml</axsl:variable>
    <axsl:variable name="testPar">
        <axsl:for-each select="document($cheminPAR)//sa_ref:Referentiel/sa_ref:Parametre">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="./sa_ref:CdParametre/text()"/>
            <axsl:text>-</axsl:text>
            <axsl:value-of select="./sa_ref:StParametre/text()"/>
            <axsl:text>'</axsl:text>
            <axsl:if test="position()!=last()">
                <axsl:text>, </axsl:text>
            </axsl:if>
        </axsl:for-each>
    </axsl:variable>
    <axsl:variable name="testMet">
        <axsl:for-each select="document($cheminMET)//sa_ref:Referentiel/sa_ref:Methode">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="./sa_ref:CdMethode/text()"/>
            <axsl:text>-</axsl:text>
            <axsl:value-of select="./sa_ref:StMethode/text()"/>
            <axsl:text>'</axsl:text>
            <axsl:if test="position()!=last()">
                <axsl:text>, </axsl:text>
            </axsl:if>
        </axsl:for-each>
    </axsl:variable>
    <axsl:variable name="testSup">
        <axsl:for-each select="document($cheminSUP)//sa_ref:Referentiel/sa_ref:Support">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="./sa_ref:CdSupport/text()"/>
            <axsl:text>-</axsl:text>
            <axsl:value-of select="./sa_ref:StSupport/text()"/>
            <axsl:text>'</axsl:text>
            <axsl:if test="position()!=last()">
                <axsl:text>, </axsl:text>
            </axsl:if>
        </axsl:for-each>
    </axsl:variable>
    <axsl:variable name="testFan">
        <axsl:for-each select="document($cheminFAN)//sa_ref:Referentiel/sa_ref:FractionAnalysee">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="./sa_ref:CdFractionAnalysee/text()"/>
            <axsl:text>-</axsl:text>
            <axsl:value-of select="./sa_ref:StFractionAnalysee/text()"/>
            <axsl:text>'</axsl:text>
            <axsl:if test="position()!=last()">
                <axsl:text>, </axsl:text>
            </axsl:if>
        </axsl:for-each>
    </axsl:variable>
    <axsl:variable name="testUrf">
        <axsl:for-each select="document($cheminURF)//sa_ref:Referentiel/sa_ref:UniteReference">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="./sa_ref:CdUniteReference/text()"/>
            <axsl:text>-</axsl:text>
            <axsl:value-of select="./sa_ref:StUniteReference/text()"/>
            <axsl:text>'</axsl:text>
            <axsl:if test="position()!=last()">
                <axsl:text>, </axsl:text>
            </axsl:if>
        </axsl:for-each>
    </axsl:variable>
    <axsl:template match="*|@*" mode="schematron-get-full-path">
        <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
        <axsl:text>/</axsl:text>
        <axsl:if test="count(. | ../@*) = count(../@*)">@</axsl:if>
        <axsl:value-of select="name()"/>
        <axsl:text>[</axsl:text>
        <axsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
        <axsl:text>]</axsl:text>
    </axsl:template>
    <axsl:template match="/">
        <axsl:apply-templates select="/" mode="M1"/>
    </axsl:template>
    <axsl:template match="//*[name()='CdParametre']" priority="4000" mode="M1">
        <axsl:variable name="valueTestPar">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Validé'</axsl:text>
        </axsl:variable>
        <axsl:variable name="valueTestParGelé">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Gelé'</axsl:text>
        </axsl:variable>
        <axsl:choose>
            <axsl:when test="contains($testPar, $valueTestPar)"/>
            <axsl:otherwise>
                <axsl:choose>
                    <axsl:when test="contains($testPar, $valueTestParGelé)">A3.2/Le code '<axsl:value-of select="text()"/>' est gelé au regard de la liste de référence des paramètres.#
	</axsl:when>
                    <axsl:otherwise>E3.1/Le code '<axsl:value-of select="text()"/>' est inconnu au regard de la liste de référence des paramètres.#
	</axsl:otherwise>
                </axsl:choose>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="*[local-name()='CdMethode']" priority="3999" mode="M1">
        <axsl:variable name="valueTestMet">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Validé'</axsl:text>
        </axsl:variable>
        <axsl:variable name="valueTestMetGelé">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Gelé'</axsl:text>
        </axsl:variable>
        <axsl:choose>
            <axsl:when test="contains($testMet, $valueTestMet)"/>
            <axsl:otherwise>
                <axsl:choose>
                    <axsl:when test="contains($testMet, $valueTestMetGelé)"> A3.2/Le code '<axsl:value-of select="text()"/>' est gelé au regard de la liste de référence des méthodes.#
	</axsl:when>
                    <axsl:otherwise>E3.1/Le code '<axsl:value-of select="text()"/>' est inconnu au regard de la liste de référence des méthodes.#
	</axsl:otherwise>
                </axsl:choose>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="*[name()='CdSupport']" priority="3998" mode="M1">
        <axsl:variable name="valueTestSup">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Validé'</axsl:text>
        </axsl:variable>
        <axsl:variable name="valueTestSupGelé">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Gelé'</axsl:text>
        </axsl:variable>
        <axsl:choose>
            <axsl:when test="contains($testSup, $valueTestSup)"/>
            <axsl:otherwise>
                <axsl:choose>
                    <axsl:when test="contains($testSup, $valueTestSupGelé)">A3.2/Le code '<axsl:value-of select="text()"/>' est gelé au regard de la liste de référence des supports.#
	</axsl:when>
                    <axsl:otherwise>E3.1/Le code '<axsl:value-of select="text()"/>' est inconnu au regard de la liste de référence des supports.#
	</axsl:otherwise>
                </axsl:choose>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="*[local-name()='CdUniteReference']" priority="3997" mode="M1">
        <axsl:variable name="valueTestUrf">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Validé'</axsl:text>
        </axsl:variable>
        <axsl:variable name="valueTestUrfGelé">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Gelé'</axsl:text>
        </axsl:variable>
        <axsl:choose>
            <axsl:when test="contains($testUrf, $valueTestUrf)"/>
            <axsl:otherwise>
                <axsl:choose>
                    <axsl:when test="contains($testUrf, $valueTestUrfGelé)">A3.2/Le code '<axsl:value-of select="text()"/>' est gelé au regard de la liste de référence des unités de mesure.#
	</axsl:when>
                    <axsl:otherwise>E3.1/Le code '<axsl:value-of select="text()"/>' est inconnu au regard de la liste de référence des unités de mesure.#
	</axsl:otherwise>
                </axsl:choose>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="*[local-name()='CdUniteMesure']" priority="3997" mode="M1">
        <axsl:variable name="valueTestUrf">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Validé'</axsl:text>
        </axsl:variable>
        <axsl:variable name="valueTestUrfGelé">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Gelé'</axsl:text>
        </axsl:variable>
        <axsl:choose>
            <axsl:when test="contains($testUrf, $valueTestUrf)"/>
            <axsl:otherwise>
                <axsl:choose>
                    <axsl:when test="contains($testUrf, $valueTestUrfGelé)">A3.2/Le code '<axsl:value-of select="text()"/>' est gelé au regard de la liste de référence des unités de mesure.#
	</axsl:when>
                    <axsl:otherwise>E3.1/Le code '<axsl:value-of select="text()"/>' est inconnu au regard de la liste de référence des unités de mesure.#
	</axsl:otherwise>
                </axsl:choose>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="*[local-name()='CdFractionAnalysee']" priority="3996" mode="M1">
        <axsl:variable name="valueTestFan">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Validé'</axsl:text>
        </axsl:variable>
        <axsl:variable name="valueTestFanGelé">
            <axsl:text>'</axsl:text>
            <axsl:value-of select="current()"/>
            <axsl:text>-Gelé'</axsl:text>
        </axsl:variable>
        <axsl:choose>
            <axsl:when test="contains($testFan, $valueTestFan)"/>
            <axsl:otherwise>
                <axsl:choose>
                    <axsl:when test="contains($testFan, $valueTestFanGelé)">A3.2/Le code '<axsl:value-of select="text()"/>' est gelé au regard de la liste de référence des fractions analysées.#
	</axsl:when>
                    <axsl:otherwise>E3.1/Le code '<axsl:value-of select="text()"/>' est inconnu au regard de la liste de référence des fractions analysées.#
	</axsl:otherwise>
                </axsl:choose>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    
  <!-- VERIFICATION DU JEU DE DONNEES DES STATIONS DE MESURE COURS D'EAU PLAN D'EAU -->
    <axsl:template match="/xx:LABO_DEST/xx:Demande/xx:Prelevement/xx:StationPrelevement/xx:CdStationPrelevement[./@schemeAgencyID='1']" priority="4000" mode="M1">
        <axsl:choose>
            <axsl:when test="document($cheminSTQ)//sa_ref31:Referentiel/sa_ref31:StationMesureEauxSurface/sa_ref31:CdStationMesureEauxSurface/text()=./text()">
                <axsl:if test="document($cheminSTQ)//sa_ref31:Referentiel/sa_ref31:StationMesureEauxSurface[./sa_ref31:CdStationMesureEauxSurface/text()=current()/text()]/sa_ref31:StStationMesure/text()='Gelé'">
                    A3.2/Avertissement: le code '<axsl:value-of select="./text()"/>' est gelé au regard de la liste de référence des stations de mesure QES (cours d'eau, plans d'eau)#
                </axsl:if>
            </axsl:when>
            <axsl:otherwise>A3.1/Avertissement: le code '<axsl:value-of select="./text()"/>' est inconnu au regard de la liste de référence des stations de mesure cours d'eau plans d'eau#
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    
<!-- VERIFICATION DU JEU DE DONNEES DES SYSTEMES DE TRAITEMENT DES EAUX USEES -->
    <axsl:template match="/xx:LABO_DEST/xx:Demande/xx:Prelevement/xx:StationPrelevement/xx:CdStationPrelevement[./@schemeAgencyID='5']" priority="4000" mode="M1">
        <axsl:choose>
            <axsl:when test="document($cheminODP)//sa_ref31:Referentiel/sa_ref31:OuvrageDepollution/sa_ref31:CdOuvrageDepollution/text()=./text()">
                <!--<axsl:if test="document($cheminODP)//sa_ref31:Referentiel/sa_ref31:OuvrageDepollution[./sa_ref31:CdOuvrageDepollution/text()=current()/text()]/sa_ref31:StStationMesure/text()='Gelé'">
                    A3.2/Avertissement: le code '<axsl:value-of select="./text()"/>' est gelé au regard de la liste de référence des stations de mesure QES (cours d'eau, plans d'eau)#
                </axsl:if>-->
            </axsl:when>
            <axsl:otherwise>A3.1/Avertissement: le code '<axsl:value-of select="./text()"/>' est inconnu au regard de la liste de référence des systèmes de traitement d'eaux usées en date du 2013-10-30#
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="*[local-name()='CdIntervenant'][./@schemeAgencyID='SIRET']" priority="4000" mode="M1">
        <axsl:choose>
            <axsl:when test="string-length(text())!=14">
E4.47/Code SIRET '<axsl:value-of select="text()"/>'  erroné. Longueur de chiffres différent de 14.#
            </axsl:when>
        </axsl:choose>
        <axsl:call-template name="controle-luhn">
            <axsl:with-param name="numero" select="text()"/>
            <axsl:with-param name="somme" select="0"/>
            <axsl:with-param name="indice" select="1"/>
        </axsl:call-template>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template name="controle-luhn">
        <axsl:param name="numero" select="normalize-space(.)"/>
        <axsl:param name="somme" select="0"/>
        <axsl:param name="indice" select="1"/>
        <axsl:choose>
            <axsl:when test="string-length($numero)=0">
                <!-- Nous arrivons ici après le dernier chiffre -->
                <axsl:choose>
                    <axsl:when test="$somme mod 10 = 0"/>
                    <axsl:otherwise>E3.3/Le code SIRET '<axsl:value-of select="text()"/>' est erroné au regard du contrôle de la formule de Luhn, la somme <axsl:value-of select="$somme"/> n'est pas un multiple de 10.#
                  </axsl:otherwise>
                </axsl:choose>
            </axsl:when>
                        <!-- test sur les 14 chiffres-->
           <!-- <axsl:when test="string-length(text())!=14">
E4.47/Code SIRET '<axsl:value-of select="text()"/>'  erroné. Longueur de chiffres différent de 14.#
            </axsl:when>-->
            <axsl:when test="$indice mod 2 = 0">
                <!-- Cas des chiffres d'indice pair -->
                <axsl:call-template name="controle-luhn">
                    <axsl:with-param name="numero" select="substring($numero, 2)"/>
                    <axsl:with-param name="somme" select="$somme + substring($numero, 1, 1)"/>
                    <axsl:with-param name="indice" select="$indice + 1"/>
                </axsl:call-template>
            </axsl:when>
            <axsl:otherwise>
                <!-- Cas des chiffres d'indice impair -->
                <axsl:variable name="double" select="concat(substring($numero, 1, 1) * 2, '0') "/>
                <axsl:call-template name="controle-luhn">
                    <axsl:with-param name="numero" select="substring($numero, 2)"/>
                    <axsl:with-param name="somme" select="$somme + substring($double, 1, 1) + substring($double, 2, 1)"/>
                    <axsl:with-param name="indice" select="$indice + 1"/>
                </axsl:call-template>
            </axsl:otherwise>
        </axsl:choose>
        <axsl:apply-templates mode="M1"/>
    </axsl:template>
    <axsl:template match="text()" priority="-1" mode="M1"/>
    <axsl:template match="text()" priority="-1"/>
</axsl:stylesheet>